$(document).ready(function () {
    //共用--返回最上面
    $('.go-top').css('cursor', 'pointer'); // 顯示手型指標

    $('.go-top').click(function () {
        window.scrollTo({ top: 0, behavior: 'smooth' }); // 使用原生的平滑滾動
    });

    //
    // ======= 會員頁:收合訂單資訊 ======
    $('.button-accordion').on("click", function () {
        $(this).toggleClass('expand')
        $(this).parents('.table-record-item').find('.record-detail').toggleClass('expand')
    })
    // ======= 會員頁:日期選取 ======
    // $( "#search_start_time" ).datepicker();
    if ($("#search_start_time").length) {
        $(function () {
            $.datepicker.regional['zh-TW'] = {
                closeText: '關閉',
                prevText: '&#x3C;上月',
                nextText: '下月&#x3E;',
                currentText: '今天',
                monthNames: ['一月', '二月', '三月', '四月', '五月', '六月',
                    '七月', '八月', '九月', '十月', '十一月', '十二月'],
                monthNamesShort: ['一月', '二月', '三月', '四月', '五月', '六月',
                    '七月', '八月', '九月', '十月', '十一月', '十二月'],
                dayNames: ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'],
                dayNamesShort: ['周日', '周一', '周二', '周三', '周四', '周五', '周六'],
                dayNamesMin: ['日', '一', '二', '三', '四', '五', '六'],
                weekHeader: '周',
                dateFormat: 'yy-mm-dd',
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: true,
                yearSuffix: '年'
            };
            $.datepicker.setDefaults($.datepicker.regional['zh-TW']);

            // $("#datepicker").datepicker({
            //     changeYear: true
            // });
            $("#search_start_time").datepicker({
                changeYear: true,
                changeMonth: true
            });
            $("#search_end_time").datepicker({
                changeYear: true,
                changeMonth: true
            });
        });
    }

    // ======= 詢價單：載入詢價單清單 ======

    // JS 產出詢價單商品項目
    // let showInquiryList = function () {
    //     let itemsincart = JSON.parse(localStorage.getItem('itemsincart'));
    //     let totalPrice = 0;
    //     let discountPrice = parseInt($('.discount-price').text())
    //     let finalPrice = 0;
    //     $('.inquiry-list').children('.inquiry-row').remove();
    //     if (itemsincart.length) {
    //         $.each(itemsincart, function (index, item) {
    //             let title = item.title;
    //             let id = item.id;
    //             let quantity = item.quantity;
    //             let original = item.original;
    //             let price = item.price;
    //             let inquiryRowTemplate = `
    //             <div class="inquiry-row"> 
    //                 <div class="remove-width">
    //                     <button class="product-remove"  data-id="${id}"> </button>
    //                 </div>
    //                 <div class="product-img"> 
    //                     <img src="./src/product/product_1.png" alt=""></div>
    //                 <div class="product-width">
    //                     <div class="product-title"> 
    //                         <span> ${title} </span></div>
    //                     <div class="text-width"> <span>數量</span></div>
    //                     <div class="quantity" data-id="${id}" data-max="5"> 
    //                         <button class="minus">+</button>
    //                         <input class="quantity-total" type="number" name="quantity" value="${parseInt(quantity)}" max="5">
    //                         <button class="plus">-</button>
    //                     </div>
    //                 </div>
    //                 <div class="price-name-width"></div>
    //                 <div class="price-width">
    //                     <span class="original-price" data-unit-price="${parseInt(original)}">${parseInt(original) * parseInt(quantity)} </span>
    //                     <span class="current-price" data-unit-price="${parseInt(price)}">${parseInt(price) * parseInt(quantity)} </span>
    //                     </div>
    //             </div>
    //         `
    //             // 計算總價
    //             totalPrice += parseInt(price) * parseInt(quantity)
    //             $('.inquiry-list').prepend(inquiryRowTemplate)
    //         })
    //     } else {
    //         let blankTemplate = `
    //             <div class="inquiry-row"> 
    //                 <div class="blank-info"> 
    //                     <span>請將商品加入詢價單</span>
    //                 </div>

    //             </div>
    //         `
    //         $('.inquiry-list').prepend(blankTemplate)
    //     }
    //     finalPrice = totalPrice - discountPrice
    //     $('.total-price').text(finalPrice)
    // }
    // showInquiryList();

    // 計算總價
    let countTotalPirce = function () {
        let price = 0
        $('.inquiry-list').find('.inquiry-row').each(function () {
            let productPrice = $(this).find('.current-price').text()
            price += parseInt(productPrice)
        })
        $('.total-price').text(price)
    }
    // ======= 詢價單：清除折扣碼 ======
    $('.remove-discount').on("click", function () {
        $(this).siblings('input').val('')
    })
    // ======= 詢價單：清除折扣碼 ======
    $('.discount-active').on("click", function () {
        $(this).siblings('input').val('')
    })

    // ======= 詢價單：數量增減 ======
    $(".quantity").each(function () {
        $(this).on("click", function (event) {
            let id = $(this).attr('data-id');
            let product = $(this).parents('.inquiry-row');
            let porductQuantity = product.find('.quantity-total');
            let porductQuantityMax = $(this).attr('data-max');
            let unitOriginPrice = parseInt($(this).parents('.inquiry-row').find('.original-price').attr('data-unit-price'), 10);
            let unitPrice = parseInt($(this).parents('.inquiry-row').find('.current-price').attr('data-unit-price'), 10);
            let originPrice = $(this).parents('.inquiry-row').find('.original-price');
            let price = $(this).parents('.inquiry-row').find('.current-price');
            let currentQuantity = parseInt(porductQuantity.val(), 10)
            let itemsincart = JSON.parse(localStorage.getItem('itemsincart'));

            if (event.target.className === 'minus') {
                if (porductQuantity.val() > 1) {
                    currentQuantity--
                    let qty = currentQuantity
                    porductQuantity.val(qty);
                    porductQuantity.attr('value', qty);
                    changeShoppingCarData(product, id);

                    originPrice.text(unitOriginPrice * parseInt(qty))
                    price.text(unitPrice * parseInt(qty))
                }
            }
            if (event.target.className === 'plus') {
                if (porductQuantityMax > porductQuantity.val()) {
                    currentQuantity++
                    let qty = currentQuantity
                    porductQuantity.val(qty);
                    porductQuantity.attr('value', qty);
                    changeShoppingCarData(product, id);

                    originPrice.text(unitOriginPrice * parseInt(qty))
                    price.text(unitPrice * parseInt(qty))
                } else {
                    // alert('已達最大數量!');
                    Swal.fire({
                        title: "已達最大數量",
                        confirmButtonText: "確認",
                        confirmButtonColor: "rgb(187 149 106);",
                        timer: 1000,
                        timerProgressBar: true,
                        customClass: {
                            title: 'lightbox-title',
                            closeButton: 'lightbox-close',
                            container: 'lightbox-alert',
                            actions: 'alert-btn-wrap',
                            confirmButton: "alert-btn alert-btn-filled",
                        },
                    });
                }

            }
            let setNewQuantityPrice = function (qty) {
                porductQuantity.val(qty);
                porductQuantity.attr('value', qty);
                changeShoppingCarData(product, id);

                originPrice.text(unitOriginPrice * parseInt(qty))
                price.text(unitPrice * parseInt(qty))
            }
            countTotalPirce();


        });
    })
    // 詢價單：刪除詢價單商品
    $('.product-remove').on("click", function (event) {
        let id = $(this).attr('data-id');
        let all_cart_items = [];
        let all_cart_items_id = [];
        if (localStorage.getItem('itemsincart')) {
            all_cart_items = JSON.parse(localStorage.getItem('itemsincart'));
            all_cart_items_id = all_cart_items.map(item => item.unique);
        }

        // 判斷重複
        let find_same_index = all_cart_items_id.indexOf(id);
        if (find_same_index > -1) {
            all_cart_items.splice(find_same_index, 1);
        }
        localStorage.setItem('itemsincart', JSON.stringify(all_cart_items));
        $(this).parents('.inquiry-row').remove()
        countTotalPirce();
    })

    // 詢價單：聯絡資訊表單驗證
    $('#contactForm').submit(function (e) {

        // 阻止表單的默認提交行為
        e.preventDefault();
        $('#productInfo').val(localStorage.getItem('itemsincart'));
        // 準備表單資料
        var formData = {
            productInfo: $('#productInfo').val(),
            recipient: $('input[name="recipient"]').val(),
            phone: $('input[name="phone"]').val(),
            address: $('input[name="address"]').val(),
            walkIn: $('#walkIn-select').find(":selected").text(),
            email: $('input[name="email"]').val(),
            contactTime: $('#contact-time').find(":selected").text(),
            memo: $('textarea').val(),
        };

        if (!formData.recipient || !formData.phone || !formData.address ||
            !formData.walkIn || !formData.email || !formData.contactTime) {
            Swal.fire({
                title: '請確保所有欄位都已填寫',
                confirmButtonText: '確認',
                confirmButtonColor: "rgb(187 149 106)",
                timer: 1000,
                timerProgressBar: true,
                customClass: {
                    title: 'lightbox-title',
                    closeButton: 'lightbox-close',
                    container: 'lightbox-alert',
                    actions: 'alert-btn-wrap',
                    confirmButton: "alert-btn alert-btn-filled",
                },
            })
            return;
        }



        return false;

        // 使用 jQuery 的 ajax 方法發送 POST 請求
        $.ajax({
            type: 'POST',
            url: '/inquiry.php',
            data: formData,
            success: function (response) {
                if (response.indexOf('500') !== -1) {
                    var updatedText = response.replace('500', '');
                    Swal.fire({
                        title: updatedText,
                        confirmButtonText: '確認',
                        confirmButtonColor: "rgb(187 149 106)",
                        timer: 1000,
                        timerProgressBar: true,
                        customClass: {
                            title: 'lightbox-title',
                            closeButton: 'lightbox-close',
                            container: 'lightbox-alert',
                            actions: 'alert-btn-wrap',
                            confirmButton: "alert-btn alert-btn-filled",
                        },
                    })
                    return;
                } else {
                    Swal.fire({
                        title: response,
                        confirmButtonText: '確認',
                        confirmButtonColor: "rgb(187 149 106)",
                        timer: 1000,
                        timerProgressBar: true,
                        customClass: {
                            title: 'lightbox-title',
                            closeButton: 'lightbox-close',
                            container: 'lightbox-alert',
                            actions: 'alert-btn-wrap',
                            confirmButton: "alert-btn alert-btn-filled",
                        },
                        willClose: () => {
                            location.reload()
                            return;
                        }
                    })
                }

            },
            error: function (xhr, status, error) {
                Swal.fire({
                    title: '登入失敗',
                    confirmButtonText: '確認',
                    confirmButtonColor: "rgb(187 149 106)",
                    timer: 1000,
                    timerProgressBar: true,
                    customClass: {
                        title: 'lightbox-title',
                        closeButton: 'lightbox-close',
                        container: 'lightbox-alert',
                        actions: 'alert-btn-wrap',
                        confirmButton: "alert-btn alert-btn-filled",
                    },
                })
                return;
            }
        });
    });


    // ======= 商品頁：數量增減 ======
    $(".quantity-selector").each(function () {
        $(this).on("click", function (event) {
            let porductQuantityMax = $(this).attr('data-max');
            let porductQuantity = $(this).find('.quantity-total');
            let currentQuantity = parseInt(porductQuantity.val(), 10)
            if (event.target.className === 'minus') {
                if (porductQuantity.val() > 1) {
                    porductQuantity.val(currentQuantity - 1);
                    porductQuantity.attr('value', currentQuantity - 1)
                }
            }
            if (event.target.className === 'plus') {
                if (porductQuantityMax > porductQuantity.val()) {
                    porductQuantity.val(currentQuantity + 1);
                    porductQuantity.attr('value', currentQuantity + 1)
                } else {
                    // alert('已達最大數量!');
                    Swal.fire({
                        title: "已達最大數量",
                        confirmButtonText: "確認",
                        confirmButtonColor: "rgb(187 149 106);",
                        timer: 1000,
                        timerProgressBar: true,
                        customClass: {
                            title: 'lightbox-title',
                            closeButton: 'lightbox-close',
                            container: 'lightbox-alert',
                            actions: 'alert-btn-wrap',
                            confirmButton: "alert-btn alert-btn-filled",
                        },
                    });
                }

            }
        });
    })
    // ======= 商品總覽：tab 切換 ======
    $('.tab-item').each(function (index) {
        $(this).on("click", function () {
            $(this).siblings().removeClass('active');
            $(this).addClass('active')
        });
    })

    // ======= 首頁：banner 輪播 ======
    $('.carousel-banner').slick({
        slidesToShow: 1,
        slidesToScroll: 1,
        centerMode: true,
        centerPadding: '11%',
        focusOnSelect: true,
        autoplay: true,
        autoplaySpeed: 4000,
        responsive: [
            {
                breakpoint: 768,
                settings: {
                    centerPadding: '0',
                }
            },
        ],
    });

    // ======= 首頁：最新消息輪播 ======
    $('.carousel-news').slick({
        infinite: true,
        slidesToShow: 4,
        slidesToScroll: 4,
        ocusOnSelect: true,
        responsive: [
            {
                breakpoint: 1024,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 3,
                }
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 2,
                }
            },
            {
                breakpoint: 548,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                }
            },
        ],
    });

    // =======  共用：登入 lightbox ======
    let openLoginLightbox = function () {

        Swal.fire({
            width: '580px',
            showConfirmButton: false,
            showCloseButton: true,
            html: `
            <div class="login-lightbox-content">
                <h2 class="login-lightbox-title">
                    <i class="menber-icon"></i>
                    會員登入</h2>
                <div class="login-btn-wrap">
                    <button class="login-btn facebook-login"> 
                        <i class="login-btn-icon facebook-icon"></i>
                        <span>使用facebook登入</span>
                    </button>
                    <button class="login-btn line-login"> 
                        <i class="login-btn-icon line-icon"></i>
                        <span>使用line登入</span>
                    </button>
                </div>
            </div>
            `,
            customClass: {
                closeButton: 'lightbox-close',
                htmlContainer: 'lightbox-container',
                container: 'lightbox',
            },
        })
    }
    $('[data-lightbox="login"]').each(function (index) {
        $(this).on("click", function () {
            openLoginLightbox();
        });
    })
    // =======  共用：搜尋 lightbox ======
    let openSearchLightbox = function () {

        Swal.fire({
            showConfirmButton: false,
            showCancelButton: false,
            width: '100%',
            background: "transparent",
            html: `
            <form action="" >
            <div class="search-lightbox-content">
                <button class="search-close"> 刪除 </button>
                <div class="search-input"> 
                    <input id="search" type="search" placeholder="輸入關鍵字"/>
                    </div>
                    
                    <input id="search" type="submit" class="search-search" />
            </div>
            </form>
            `,
            customClass: {
                htmlContainer: 'search-lightbox',
            },
            didRender: () => {
                let closeBtn = document.querySelector('.search-close');
                closeBtn.addEventListener('click', function () {
                    Swal.close()
                })
            }
        })
    }
    $('[data-lightbox="search"]').each(function (index) {
        $(this).on("click", function () {
            openSearchLightbox();
        });
    })

    // =======  共用：20+ lightbox ======
    let open20plusLightbox = function () {
        Swal.fire({
            width: '580px',
            showCloseButton: true,
            showConfirmButton: true,
            confirmButtonText: '已滿20歲',
            focusClose: false,
            focusConfirm: false,
            showCancelButton: true,
            allowOutsideClick: false,
            cancelButtonText: '未滿20歲',
            html: `
            <div class="legal-age-lightbox-content">
                <div class="legal-age-img"></div>
                <h2 class="legal-age-lightbox-title">
                    未成年禁止飲酒
                    <br/>
                    本網站須滿20歲才可瀏覽</h2>
                <p>根據菸酒管理法第30 條規定，酒之販賣或轉讓不得以自動販賣機、郵購、電子購物或其他無法辨識購買者或受讓者年齡等方式為之。</p>
                <p>兒童及少年福利與權益保障法第 43 條規定，任何人不得供應菸酒予兒童及少年，違反者依各法裁處1 萬元以上 5 萬元以下罰緩。</p>
            </div>
                `,
            customClass: {
                closeButton: 'lightbox-close',
                htmlContainer: 'lightbox-container',
                container: 'lightbox',
                actions: 'legal-age-btn-wrap',
                confirmButton: "legal-age-btn legal-age-btn-filled",
                cancelButton: "legal-age-btn legal-age-btn-outline",
            },
        }).then((result) => {
            if (result.isConfirmed) {
                // 點確認已滿20歲存COOKIE
                document.cookie = 'leagalAge=confirm';
                return true;
            } else if (
                result.dismiss === Swal.DismissReason.cancel ||
                result.dismiss === Swal.DismissReason.close
            ) {
                // 未滿18歲或點Ｘ，開啟空白頁
                window.open('about:blank', '_self');
            }
        });
    }


    // 取得 COOKIE
    function getCookie(name) {
        const value = `; ${document.cookie}`;
        const parts = value.split(`; ${name}=`);
        if (parts.length === 2) return parts.pop().split(';').shift();
    }
    // 清除 
    function delete_cookie(name) {
        document.cookie = name + '=; Path=/; Expires=Thu, 01 Jan 1970 00:00:01 GMT;';
    }
    // 沒點過已滿20歲顯示警示 lightbox
    if (!getCookie('leagalAge')) {
        open20plusLightbox();
    }



    // ======= 共用： mobile menu ======
    $('#mobile-menu-button').click(function () {
        $('.mobile-menu').addClass('expand');
        $('body').css("overflow", "hidden");
    })

    $('.mobile-menu-close').click(function () {
        $('.mobile-menu').removeClass('expand');
        $('body').css("overflow", "auto");
    })
    // =======  共用： 加入收藏 ======
    $('.add-to-follow').each(function (index) {
        $(this).on("click", function () {

            let proID = $(this).attr('data-id');
            if ($(this).attr('class').indexOf('active') > 0) {
                $(this).removeClass('active');
            } else {
                $(this).addClass('active');
            }
        });
    })
    // =======  共用： dropdown ======
    $('.dropdown-button').each(function (index) {
        $(this).on("click", function () {
            $(this).siblings('.dropdown-menu').toggleClass('expand');
            $(this).toggleClass('expand');
        });
    })

    // =======  共用：淡入淡出動畫啟用 ======
    AOS.init();

});


// 購物車更改資料(共用)
function changeShoppingCarData(product, id) {
    let title = product.find('.product-title').text();
    let price = product.find('.current-price').attr('data-unit-price');
    let original = product.find('.original-price').attr('data-unit-price');
    let specifications = '';
    let quantity = product.find('.quantity-total').val();
    let all_cart_items = [];
    let all_cart_items_id = [];

    if (!quantity) {
        quantity = 1;
    }

    if (localStorage.getItem('itemsincart')) {
        all_cart_items = JSON.parse(localStorage.getItem('itemsincart'));
        all_cart_items_id = all_cart_items.map(item => item.unique);
    }

    let find_unique = id;
    if (product.parents('.product-list').length > 0) {
        find_unique = product.attr('data-id');

    }

    // 判斷是否重複
    let find_same_index = all_cart_items_id.indexOf(find_unique);
    if (find_same_index > -1) {
        all_cart_items.splice(find_same_index, 1);
    }

    all_cart_items.push({
        unique: id,
        id: id,
        price: price,
        original: original,
        title: title,
        specifications: specifications,
        quantity: quantity
    });
    localStorage.setItem('itemsincart', JSON.stringify(all_cart_items));
    // console.log(localStorage.getItem('itemsincart'))
}
// console.log(localStorage.getItem('itemsincart'))
// localStorage.removeItem("itemsincart");



// 購物車 - 新增產品
function addProductToCart() {
    $(".add-to-inquiry").on("click", function () {
        let id = $(this).attr("data-id");
        let product = $(this).parents(".content-info");

        changeShoppingCarData(product, id);
        // 更新一次
        // 改存COOKIE
        document.cookie = "itemsincart=''";
        var itemsincart = localStorage.getItem("itemsincart");
        document.cookie = "itemsincart=" + itemsincart;
        let data = localStorage.getItem("itemsincart");


        // alert('加入成功!');
        Swal.fire({
            title: "加入成功!<br>(購物車目前" + JSON.parse(data).length + "項商品)",
            confirmButtonText: "確認",
            confirmButtonColor: "rgb(187 149 106);",
            timer: 1000,
            timerProgressBar: true,
            customClass: {
                title: 'lightbox-title',
                closeButton: 'lightbox-close',
                container: 'lightbox-alert',
                actions: 'alert-btn-wrap',
                confirmButton: "alert-btn alert-btn-filled",
            },
        });

    });
}
addProductToCart()

// 購物車 - 增減數量
function increaseOrDecrease() {
    // $('.product-item').on('change', '.quantity-total', function() {

    //     let max_quantity = $(this).parents('.quantity-box').attr("data-max");
    //     let total = $(this).val();
    //     if (parseInt(total) >= max_quantity) {
    //         // alert('已達上限!');
    //         Swal.fire({
    //             title: '已達上限',
    //             confirmButtonText: '確認',
    //             confirmButtonColor: 'rgb(64 71 72)',
    //             timer: 1000,
    //             timerProgressBar: true,
    //         })
    //         $(this).val(max_quantity);
    //     }

    //     // 更新一次
    //     // 改存COOKIE
    //     document.cookie="itemsincart=''";
    //     var itemsincart = localStorage.getItem('itemsincart');
    //     document.cookie="itemsincart="+itemsincart;
    // });

    // $('.quantity-box').find('.icon-remove').click(function() {
    //     let product = $(this).parents('.product-item');
    //     let total = $(this).siblings('.quantity-total').val();
    //     let id = product.attr("data-id");
    //     if (parseInt(total) > 1) {
    //         $(this).siblings('.quantity-total').val(parseInt(total) - 1);
    //         product.find('.quantity-total').val(parseInt(total) - 1);
    //     }
    //     calculateItemSubtotals(product);
    //     if ($(this).parents('.product-list').length >0) {
    //         changeShoppingCarData(product, id);
    //     }

    //     // 更新一次
    //     // 改存COOKIE
    //     document.cookie="itemsincart=''";
    //     var itemsincart = localStorage.getItem('itemsincart');
    //     document.cookie="itemsincart="+itemsincart;
    // });
    // $('.quantity-box').find('.icon-add').click(function() {
    //     let max_quantity = $(this).parents('.quantity-box').attr("data-max");
    //     let product = $(this).parents('.product-item');
    //     let total = $(this).siblings('.quantity-total').val();
    //     let id = product.attr("data-id");

    //     if (parseInt(total) == max_quantity) {
    //         // alert('已達上限!');
    //         Swal.fire({
    //             title: '已達上限',
    //             confirmButtonText: '確認',
    //             confirmButtonColor: 'rgb(64 71 72)',
    //             timer: 1000,
    //             timerProgressBar: true,
    //         })
    //     }
    //     if (parseInt(total) >= 0 &&　parseInt(total) < max_quantity) {
    //         $(this).siblings('.quantity-total').val(parseInt(total) + 1);
    //         product.find('.quantity-total').val(parseInt(total) + 1);
    //     }
    //     calculateItemSubtotals(product);
    //     if ($(this).parents('.product-list').length > 0) {
    //         changeShoppingCarData(product, id);
    //     }

    //     // 更新一次
    //     // 改存COOKIE
    //     document.cookie="itemsincart=''";
    //     var itemsincart = localStorage.getItem('itemsincart');
    //     document.cookie="itemsincart="+itemsincart;
    // });
}

// 購物車 - 計算小計
function calculateItemSubtotals(product) {
    let total = product.find('.quantity-total').val();
    let price = getNumber(product.find('.price b').text());
    // let original = getNumber(product.find('.original b').text());
    let final_price = separatorNumber(price * total);
    // let final_original = separatorNumber(original * total);
    product.find('.special-price b').text(final_price);
    // product.find('.original_special-price').text(final_original);
    calculateLumpSum();

    // 更新一次
    // 改存COOKIE
    document.cookie = "itemsincart=''";
    var itemsincart = localStorage.getItem('itemsincart');
    document.cookie = "itemsincart=" + itemsincart;
}

// 購物車 - 計算總計
function calculateLumpSum() {
    let sum = 0;
    let amount = $('.product-list .product-item').length;
    $('.product-list .product-item').each(function () {
        let get_subtotal = getNumber($(this).find('.special-price b').text());
        sum = sum + get_subtotal;
    });


    $('.product-sum b').text(separatorNumber(sum));
    $('.total-amount b').text(amount);

    // 更新一次
    // 改存COOKIE
    document.cookie = "itemsincart=''";
    var itemsincart = localStorage.getItem('itemsincart');
    document.cookie = "itemsincart=" + itemsincart;
}

function getNumber(str) {
    str = str.replace(/,/g, "");
    return parseInt(str);
}

function separatorNumber(numb) {
    var str = numb.toString().split(".");
    str[0] = str[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    return str.join(".");
}
