
// header 控制
window.addEventListener("scroll", function scrollFunction() {
  // let totop = document.querySelector('.top');
  const header = document.querySelector("header");
  let scrollTop = document.documentElement.scrollTop;
  const scrollY = window.scrollY || window.pageYOffset;
  const triggerHeight = 100; // 捲動超過 300px 觸發

  if (scrollY > triggerHeight) {
    header.classList.add("bg");
  } else {
    header.classList.remove("bg");
  }

}, false);

// GSAP 設定
// 啟用 ScrollTrigger
gsap.registerPlugin(ScrollTrigger);

// Hero 元素（LOGO/主標/CTA）進場
gsap.from(".banner .item", {
  y: 30, opacity: 0, stagger: 0.12, duration: 0.9, ease: "power3.out",
  delay: 0.1
});

// icon 卡片
gsap.from(".intro-card-list .intro-card", {
  scrollTrigger: { trigger: ".intro-card-list", start: "top 80%" },
  y: 24, opacity: 0, stagger: 0.1, duration: 0.6, ease: "power2.out"
});

// News 區塊（條目逐一淡入）
gsap.from(".news-item", {
  scrollTrigger: { trigger: ".news-wrap ", start: "top 80%" },
  y: 16, opacity: 0, stagger: 0.08, duration: 0.5, ease: "power2.out"
});

// 產品卡
gsap.from(".product-grid .product-card", {
  scrollTrigger: { trigger: ".product-grid", start: "top 85%" },
  y: 24, opacity: 0, stagger: { each: 0.06, from: "edges" },
  duration: 0.55, ease: "power2.out"
});
gsap.from(".product-grid .category-card", {
  scrollTrigger: { trigger: ".product-grid", start: "top 85%" },
  y: 24, opacity: 0, stagger: { each: 0.06, from: "edges" },
  duration: 0.55, ease: "power2.out"
});

// 內容頁：SPEC 表與 Relative Products
gsap.from(".spec-table", {
  scrollTrigger: { trigger: ".spec-table", start: "top 85%" },
  y: 20, opacity: 0, duration: 0.5, ease: "power2.out"
});
gsap.from(".related-products .product-card", {
  scrollTrigger: { trigger: ".related-products", start: "top 85%" },
  y: 22, opacity: 0, stagger: 0.08, duration: 0.5, ease: "power2.out"
});

// 共用：任何 .fade-up 在捲到時淡入上浮
document.querySelectorAll(".fade-up").forEach((el) => {
  gsap.from(el, {
    scrollTrigger: { trigger: el, start: "top 85%" },
    y: 18, opacity: 0, duration: 0.5, ease: "power2.out"
  });
});
// 共用：任何 .fade-dowm 在捲到時淡入下降
document.querySelectorAll(".fade-down").forEach((el) => {
  gsap.from(el, {
    scrollTrigger: { trigger: el, start: "top 85%" },
    y: -18, opacity: 0, duration: 0.5, ease: "power2.out"
  });
});
document.querySelectorAll(".fade-left").forEach((el) => {
  gsap.from(el, {
    scrollTrigger: { trigger: el, start: "top 85%" },
    x: -18, opacity: 0, duration: 0.5, ease: "power2.out"
  });
});
document.querySelectorAll(".fade-right").forEach((el) => {
  gsap.from(el, {
    scrollTrigger: { trigger: el, start: "top 85%" },
    x: 18, opacity: 0, duration: 0.5, ease: "power2.out"
  });
});

// mobile menu 控制
const btn = document.querySelector(".mobile-menu-button");
const menu = document.querySelector(".mobile-menu");
const closeBtn = document.querySelector(".menu-close");
const BREAKPOINT = 1000; // 超過此寬度當桌機，用不到 mobile menu

// if (!btn || !menu || !closeBtn) return;

// 初始狀態
menu.setAttribute("aria-hidden", "true");
btn.setAttribute("aria-expanded", "false");

function lockScroll(lock) {
  document.body.classList.toggle("freeze", lock);
}

function openMenu() {
  btn.setAttribute("aria-expanded", "true");
  menu.classList.add("expand");
  menu.setAttribute("aria-hidden", "false");
  lockScroll(true);

  // 若有 GSAP，套一個小動畫（可刪）
  if (window.gsap) {
    gsap.fromTo(menu, { yPercent: -5, opacity: 0 }, { yPercent: 0, opacity: 1, duration: .25, ease: "power2.out" });
  }
}

function closeMenu() {
  btn.setAttribute("aria-expanded", "false");
  menu.classList.remove("expand");
  menu.setAttribute("aria-hidden", "true");
  lockScroll(false);

  if (window.gsap) {
    gsap.to(menu, { yPercent: -5, opacity: 0, duration: .2, ease: "power2.in" });
  }
}

function toggleMenu() {
  const isOpen = menu.classList.contains("expand");
  isOpen ? closeMenu() : openMenu();
}

// 事件
btn.addEventListener("click", toggleMenu);
closeBtn.addEventListener("click", closeMenu);

// 點選單連結就關閉
menu.addEventListener("click", (e) => {
  const a = e.target.closest(".mobile-menu-item a");
  if (a) closeMenu();
});



// 視窗放大到桌機時，確保關閉
window.addEventListener("resize", () => {
  if (window.innerWidth >= BREAKPOINT) closeMenu();
});

// 產品頁側邊欄位
if (document.querySelectorAll(".side-menu .has-sub")) {
  const items = document.querySelectorAll(".side-menu .has-sub");

  items.forEach((item) => {
    const title = item.querySelector(".menu-title");
    const submenu = item.querySelector(".submenu");

    // 預設收合
    submenu.style.maxHeight = "0px";
    submenu.style.overflow = "hidden";
    submenu.style.transition = "max-height 0.3s ease";

    title.addEventListener("click", () => {
      const isOpen = item.classList.contains("open");

      // 關閉其他項（如果希望同時只能展開一個）
      items.forEach((i) => {
        if (i !== item) {
          i.classList.remove("open");
          i.querySelector(".submenu").style.maxHeight = "0px";
        }
      });

      // 切換當前
      if (isOpen) {
        item.classList.remove("open");
        submenu.style.maxHeight = "0px";
      } else {
        item.classList.add("open");
        submenu.style.maxHeight = submenu.scrollHeight + "px";
      }
      if (window.gsap) {
        if (isOpen) {
          gsap.to(submenu, { height: 0, duration: 0.25, ease: "power2.in" });
        } else {
          gsap.fromTo(submenu, { height: 0 }, { height: submenu.scrollHeight, duration: 0.25, ease: "power2.out" });
        }
      }
    });

  });
}

//手機版分類選單篩選
const catSelect = document.getElementById("catSelect");

const subcatSelect = document.getElementById("subcatSelect");

// 所有子分類 <option> (含 data-cat)
if (catSelect) {
  const allSubOptions = Array.from(subcatSelect.querySelectorAll("option[data-cat]"));

  // 當主分類改變時
  catSelect.addEventListener("change", () => {
    const selectedCat = catSelect.value;
    console.log('s')
    // 先清空現有子分類選項（保留第一個提示用 option）
    subcatSelect.innerHTML = '<option value="" disabled selected>Select sub category</option>';

    // 篩選屬於該主分類的子項
    const filtered = allSubOptions.filter(opt => opt.dataset.cat === selectedCat);

    // 插入篩選後的子項
    filtered.forEach(opt => {
      subcatSelect.appendChild(opt.cloneNode(true));
    });

    // 開啟或關閉子分類 select
    if (filtered.length > 0) {
      subcatSelect.disabled = false;
      subcatSelect.classList.remove("disabled");
    } else {
      subcatSelect.disabled = true;
      subcatSelect.classList.add("disabled");
    }

    // 自動重置子分類選取狀態
    subcatSelect.selectedIndex = 0;
  });
}


//控制 tab 切換
const tabs = document.querySelectorAll(".tab-menu .tab-item");
if (tabs.length) {
  const params = new URLSearchParams(window.location.search);
  const tabParam = params.get("tab");

  tabs.forEach(tab => tab.classList.remove("active"));

  if (tabParam === "custom") {
    // 找到 href 裡有 tab=custom 的那個 tab
    const customTab = document.querySelector('.tab-menu .tab-item[href*="tab=custom"]');
    customTab?.classList.add("active");
  } else {
    // 沒有參數就讓第一個 tab active
    tabs[0]?.classList.add("active");
  }
}
// 聯絡表單驗證
(function () {
  const form = document.querySelector(".contact-section-3 .form");
  const tabs = document.querySelectorAll(".form-tab-menu .form-tab");
  const panels = document.querySelectorAll(".form-panel");

  // ===== Tab 切換 =====
  function showPanel(panelEl) {
    panels.forEach(p => {
      const active = p === panelEl;
      p.hidden = !active;
      p.classList.toggle("is-active", active);
      p.querySelectorAll("[data-required]").forEach(inp => inp.required = active);
    });
    tabs.forEach(t => t.classList.toggle("active", t.dataset.target === `#${panelEl.id}`));
  }
  showPanel(document.querySelector(".form-panel.is-active") || panels[0]);
  tabs.forEach(tab => {
    tab.addEventListener("click", () => {
      const target = document.querySelector(tab.dataset.target);
      if (target) showPanel(target);
    });
  });

  // ===== 動態新增/刪除項目列 =====
  function initDynamicRows(panel) {
    panel.querySelectorAll(".button-add").forEach(addBtn => {
      const formItem = addBtn.closest(".form-item");
      const wrap = formItem.querySelector("#itemsWrapNew, #itemsWrapExist");
      const tpl = formItem.querySelector("template");
      if (!wrap || !tpl) return;

      function addRow() {
        // 只從 <template> 取一列新增欄位（裡面有 .button-remove）
        if (!tpl.content || !tpl.content.firstElementChild) return;
        const node = tpl.content.firstElementChild.cloneNode(true);

        // 綁定刪除（僅對 wrap 裡的新增列有效；外層第一個固定欄位沒有 remove）
        const removeBtn = node.querySelector(".button-remove");
        if (removeBtn) {
          removeBtn.addEventListener("click", () => {
            node.remove(); // 不再檢查「至少一筆」，因為固定欄位在外層
          });
        }

        wrap.appendChild(node);
      }

      // 不主動新增列；第一個固定欄位已在外層 .input-wrap
      addBtn.addEventListener("click", addRow);
    });
  }
  panels.forEach(initDynamicRows);

  // ===== 驗證函式 =====
  function markValidity(input, isValid) {
    const item = input.closest(".form-item");
    if (item) item.classList.toggle("error", !isValid);
  }

  function validateInput(input) {
    const value = input.value.trim();
    const type = input.type.toLowerCase();
    if (!input.required) return true;
    if (!value) return false;

    if (type === "email") return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value);
    if (type === "tel") return /^[0-9()+\-\s]{6,}$/.test(value);
    if (type === "url") {
      try { new URL(value); return true; } catch { return false; }
    }
    return true;
  }

  // 即時移除錯誤樣式
  form.addEventListener("input", e => {
    const el = e.target;
    if (el.matches(".form-input, .form-textarea")) {
      markValidity(el, validateInput(el));
    }
  });

  // ===== mailto 收件設定 =====
  const SALES_EMAIL = "tim@comsurge.com";  // 改成你的收件信箱
  const SUBJECT_PREFIX = "[Website Quote]";

  // ===== 送出處理 =====
  form.addEventListener("submit", e => {
    e.preventDefault();
    const activePanel = document.querySelector(".form-panel.is-active");
    if (!activePanel) return;

    let allValid = true;
    const inputs = activePanel.querySelectorAll("[data-required]");
    inputs.forEach(input => {
      const ok = validateInput(input);
      markValidity(input, ok);
      if (!ok && allValid) input.focus();
      allValid = allValid && ok;
    });

    // 檢查項目列
    const itemWrap = activePanel.querySelector("#itemsWrapNew, #itemsWrapExist");
    if (itemWrap) {
      const rows = itemWrap.querySelectorAll("input.form-input");
      rows.forEach(inp => {
        const ok = inp.value.trim() !== "";
        markValidity(inp, ok);
        if (!ok) allValid = false;
      });
    }

    if (!allValid) {
      alert("請確認所有必填欄位皆已正確填寫。");
      return;
    }

    // === 組 Mailto 內容 ===
    function buildMailto(panel) {
      const fd = new FormData(form);        // ✅ 用整個 form
      const isNew = panel.id === "panel-new";
      const title = isNew ? "NEW CUSTOMERS" : "EXISTING CUSTOMERS";

      // 只讀「當前面板裡」的欄位值
      const get = (name) => {
        const el = panel.querySelector(`[name="${name}"]`);
        return el ? (fd.get(name) || "").toString().trim() : "";
      };

      const company = get("company");
      const address = get("address");
      const website = get("website");
      const contact = get("name");
      const phone = get("phone");
      const email = get("email");
      const descr = get("description");
      const message = get("message") || get("message2");

      // Items（第一個固定輸入 + 新增列）
      const collectItems = () => {
        const itemBlock = panel.querySelector('.form-item:has(.button-add)');
        if (!itemBlock) return [];
        const first = itemBlock.querySelector('.input-wrap > input.form-input');
        const rest = itemBlock.querySelectorAll('#itemsWrapNew input.form-input, #itemsWrapExist input.form-input');
        const vals = [];
        if (first && first.value.trim()) vals.push(first.value.trim());
        rest.forEach(i => i.value.trim() && vals.push(i.value.trim()));
        return vals;
      };
      const items = collectItems();

      const SUBJECT_PREFIX = "[Website Quote]";
      const SALES_EMAIL = "tim@comsurge.com";   // ← 改成你的收件者
      const CC_EMAIL = "";                   // 有需要再填

      const lines = [
        `${SUBJECT_PREFIX} ${title}`,
        "",
        `Company Name: ${company}`,
        isNew && address ? `Address: ${address}` : "",
        isNew && website ? `Website: ${website}` : "",
        `Contact Name: ${contact}`,
        `Contact Phone: ${phone}`,
        `Contact Email: ${email}`,
        "",
        isNew && descr ? "Short Business Description:" : "",
        isNew && descr ? descr : "",
        message ? "Message:" : "",
        message || "",
        "",
        (isNew ? "Part Number & Quantity:" : "Items & Quantity:"),
        ...items.map((v, i) => `${i + 1}. ${v}`)
      ].filter(Boolean);

      const subject = encodeURIComponent(`${SUBJECT_PREFIX} ${title} - ${company}`);
      const body = encodeURIComponent(lines.join("\r\n"));
      const to = encodeURIComponent(SALES_EMAIL);
      const cc = CC_EMAIL ? `&cc=${encodeURIComponent(CC_EMAIL)}` : "";
      // console.log(lines)
      // console.log(body)
      return `mailto:${to}?subject=${subject}&body=${body}${cc}`;
    }
    const mailtoURL = buildMailto(activePanel);

    // ✅ 用 <a> 觸發，成功率比直接改 location 高
    const a = document.createElement("a");
    a.href = mailtoURL;
    a.style.display = "none";
    document.body.appendChild(a);
    a.click();
    a.remove();
  });
})();

